/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.api;

import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl.api.Binding;
import dev.isxander.yacl.api.Controller;
import dev.isxander.yacl.api.OptionFlag;
import dev.isxander.yacl.impl.OptionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public interface Option<T> {
    @NotNull
    public class_2561 name();

    @NotNull
    public class_2561 tooltip();

    @NotNull
    public Controller<T> controller();

    @NotNull
    public Binding<T> binding();

    public boolean available();

    public void setAvailable(boolean var1);

    @NotNull
    public Class<T> typeClass();

    @NotNull
    public ImmutableSet<OptionFlag> flags();

    public boolean changed();

    @Deprecated
    public boolean requiresRestart();

    @NotNull
    public T pendingValue();

    public void requestSet(T var1);

    public boolean applyValue();

    public void forgetPendingValue();

    public void requestSetDefault();

    public boolean isPendingValueDefault();

    public void addListener(BiConsumer<Option<T>, T> var1);

    public static <T> Builder<T> createBuilder(Class<T> typeClass) {
        return new Builder<T>(typeClass);
    }

    public static class Builder<T> {
        private class_2561 name = class_2561.method_43470((String)"Name not specified!").method_27692(class_124.field_1061);
        private final List<Function<T, class_2561>> tooltipGetters = new ArrayList<Function<T, class_2561>>();
        private Function<Option<T>, Controller<T>> controlGetter;
        private Binding<T> binding;
        private boolean available = true;
        private boolean instant = false;
        private final Set<OptionFlag> flags = new HashSet<OptionFlag>();
        private final Class<T> typeClass;
        private final List<BiConsumer<Option<T>, T>> listeners = new ArrayList<BiConsumer<Option<T>, T>>();

        private Builder(Class<T> typeClass) {
            this.typeClass = typeClass;
        }

        public Builder<T> name(@NotNull class_2561 name) {
            Validate.notNull((Object)name, (String)"`name` cannot be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        @SafeVarargs
        public final Builder<T> tooltip(Function<T, class_2561> ... tooltipGetter) {
            Validate.notNull(tooltipGetter, (String)"`tooltipGetter` cannot be null", (Object[])new Object[0]);
            this.tooltipGetters.addAll(List.of(tooltipGetter));
            return this;
        }

        public Builder<T> tooltip(class_2561 ... tooltips) {
            Validate.notNull((Object)tooltips, (String)"`tooltips` cannot be empty", (Object[])new Object[0]);
            this.tooltipGetters.addAll(Stream.of(tooltips).map(text -> t -> text).toList());
            return this;
        }

        public Builder<T> controller(@NotNull Function<Option<T>, Controller<T>> control) {
            Validate.notNull(control, (String)"`control` cannot be null", (Object[])new Object[0]);
            this.controlGetter = control;
            return this;
        }

        public Builder<T> binding(@NotNull Binding<T> binding) {
            Validate.notNull(binding, (String)"`binding` cannot be null", (Object[])new Object[0]);
            this.binding = binding;
            return this;
        }

        public Builder<T> binding(@NotNull T def, @NotNull @NotNull Supplier<@NotNull T> getter, @NotNull @NotNull Consumer<@NotNull T> setter) {
            Validate.notNull(def, (String)"`def` must not be null", (Object[])new Object[0]);
            Validate.notNull(getter, (String)"`getter` must not be null", (Object[])new Object[0]);
            Validate.notNull(setter, (String)"`setter` must not be null", (Object[])new Object[0]);
            this.binding = Binding.generic(def, getter, setter);
            return this;
        }

        public Builder<T> available(boolean available) {
            this.available = available;
            return this;
        }

        public Builder<T> flag(OptionFlag ... flag) {
            Validate.notNull((Object)flag, (String)"`flag` must not be null", (Object[])new Object[0]);
            this.flags.addAll(Arrays.asList(flag));
            return this;
        }

        public Builder<T> flags(@NotNull Collection<OptionFlag> flags) {
            Validate.notNull(flags, (String)"`flags` must not be null", (Object[])new Object[0]);
            this.flags.addAll(flags);
            return this;
        }

        public Builder<T> instant(boolean instant) {
            this.instant = instant;
            return this;
        }

        public Builder<T> listener(@NotNull BiConsumer<Option<T>, T> listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder<T> listeners(@NotNull Collection<BiConsumer<Option<T>, T>> listeners) {
            this.listeners.addAll(listeners);
            return this;
        }

        @Deprecated
        public Builder<T> requiresRestart(boolean requiresRestart) {
            if (requiresRestart) {
                this.flag(OptionFlag.GAME_RESTART);
            } else {
                this.flags.remove(OptionFlag.GAME_RESTART);
            }
            return this;
        }

        public Option<T> build() {
            Validate.notNull(this.controlGetter, (String)"`control` must not be null when building `Option`", (Object[])new Object[0]);
            Validate.notNull(this.binding, (String)"`binding` must not be null when building `Option`", (Object[])new Object[0]);
            Validate.isTrue((!this.instant || this.flags.isEmpty() ? 1 : 0) != 0, (String)"instant application does not support option flags", (Object[])new Object[0]);
            Function<Object, class_2561> concatenatedTooltipGetter = value -> {
                class_5250 concatenatedTooltip = class_2561.method_43473();
                boolean first = true;
                for (Function<Object, class_2561> function : this.tooltipGetters) {
                    if (!first) {
                        concatenatedTooltip.method_27693("\n");
                    }
                    first = false;
                    concatenatedTooltip.method_10852(function.apply(value));
                }
                return concatenatedTooltip;
            };
            if (this.instant) {
                this.listeners.add((opt, pendingValue) -> opt.applyValue());
            }
            return new OptionImpl<Object>(this.name, concatenatedTooltipGetter, this.controlGetter, this.binding, this.available, (ImmutableSet<OptionFlag>)ImmutableSet.copyOf(this.flags), this.typeClass, this.listeners);
        }
    }
}

